<?php
session_start();
require('app/core/config/config.php');
require('app/core/config/config-theme.php');

$db->set_charset('utf8');

$users = $db->query("SELECT * FROM users ORDER BY RAND() LIMIT 7");

function getProfilePicture($domain, $user) {
    if(strpos($user['profile_picture'],'graph.facebook') || strpos($user['profile_picture'],'randomuser')) {
    return $user['profile_picture'];
    } else {
    return $domain.'/app/uploads/'.$user['profile_picture'];
    }
}

function getProtocol($domain) {
  $domain = parse_url($domain);
  return $domain['scheme'];
}

function getLocaleCodeForDisplayLanguage($name){
    $languageCodes = array(
    "aa" => "Afar",
    "ab" => "Abkhazian",
    "ae" => "Avestan",
    "af" => "Afrikaans",
    "ak" => "Akan",
    "am" => "Amharic",
    "an" => "Aragonese",
    "ar" => "Arabic",
    "as" => "Assamese",
    "av" => "Avaric",
    "ay" => "Aymara",
    "az" => "Azerbaijani",
    "ba" => "Bashkir",
    "be" => "Belarusian",
    "bg" => "Bulgarian",
    "bh" => "Bihari",
    "bi" => "Bislama",
    "bm" => "Bambara",
    "bn" => "Bengali",
    "bo" => "Tibetan",
    "br" => "Breton",
    "bs" => "Bosnian",
    "ca" => "Catalan",
    "ce" => "Chechen",
    "ch" => "Chamorro",
    "co" => "Corsican",
    "cr" => "Cree",
    "cs" => "Czech",
    "cu" => "Church Slavic",
    "cv" => "Chuvash",
    "cy" => "Welsh",
    "da" => "Danish",
    "de" => "German",
    "dv" => "Divehi",
    "dz" => "Dzongkha",
    "ee" => "Ewe",
    "el" => "Greek",
    "en" => "English",
    "eo" => "Esperanto",
    "es" => "Spanish",
    "et" => "Estonian",
    "eu" => "Basque",
    "fa" => "Persian",
    "ff" => "Fulah",
    "fi" => "Finnish",
    "fj" => "Fijian",
    "fo" => "Faroese",
    "fr" => "French",
    "fy" => "Western Frisian",
    "ga" => "Irish",
    "gd" => "Scottish Gaelic",
    "gl" => "Galician",
    "gn" => "Guarani",
    "gu" => "Gujarati",
    "gv" => "Manx",
    "ha" => "Hausa",
    "he" => "Hebrew",
    "hi" => "Hindi",
    "ho" => "Hiri Motu",
    "hr" => "Croatian",
    "ht" => "Haitian",
    "hu" => "Hungarian",
    "hy" => "Armenian",
    "hz" => "Herero",
    "ia" => "Interlingua (International Auxiliary Language Association)",
    "id" => "Indonesian",
    "ie" => "Interlingue",
    "ig" => "Igbo",
    "ii" => "Sichuan Yi",
    "ik" => "Inupiaq",
    "io" => "Ido",
    "is" => "Icelandic",
    "it" => "Italian",
    "iu" => "Inuktitut",
    "ja" => "Japanese",
    "jv" => "Javanese",
    "ka" => "Georgian",
    "kg" => "Kongo",
    "ki" => "Kikuyu",
    "kj" => "Kwanyama",
    "kk" => "Kazakh",
    "kl" => "Kalaallisut",
    "km" => "Khmer",
    "kn" => "Kannada",
    "ko" => "Korean",
    "kr" => "Kanuri",
    "ks" => "Kashmiri",
    "ku" => "Kurdish",
    "kv" => "Komi",
    "kw" => "Cornish",
    "ky" => "Kirghiz",
    "la" => "Latin",
    "lb" => "Luxembourgish",
    "lg" => "Ganda",
    "li" => "Limburgish",
    "ln" => "Lingala",
    "lo" => "Lao",
    "lt" => "Lithuanian",
    "lu" => "Luba-Katanga",
    "lv" => "Latvian",
    "mg" => "Malagasy",
    "mh" => "Marshallese",
    "mi" => "Maori",
    "mk" => "Macedonian",
    "ml" => "Malayalam",
    "mn" => "Mongolian",
    "mr" => "Marathi",
    "ms" => "Malay",
    "mt" => "Maltese",
    "my" => "Burmese",
    "na" => "Nauru",
    "nb" => "Norwegian Bokmal",
    "nd" => "North Ndebele",
    "ne" => "Nepali",
    "ng" => "Ndonga",
    "nl" => "Dutch",
    "nn" => "Norwegian Nynorsk",
    "no" => "Norwegian",
    "nr" => "South Ndebele",
    "nv" => "Navajo",
    "ny" => "Chichewa",
    "oc" => "Occitan",
    "oj" => "Ojibwa",
    "om" => "Oromo",
    "or" => "Oriya",
    "os" => "Ossetian",
    "pa" => "Panjabi",
    "pi" => "Pali",
    "pl" => "Polish",
    "ps" => "Pashto",
    "pt" => "Portuguese",
    "qu" => "Quechua",
    "rm" => "Raeto-Romance",
    "rn" => "Kirundi",
    "ro" => "Romanian",
    "ru" => "Russian",
    "rw" => "Kinyarwanda",
    "sa" => "Sanskrit",
    "sc" => "Sardinian",
    "sd" => "Sindhi",
    "se" => "Northern Sami",
    "sg" => "Sango",
    "si" => "Sinhala",
    "sk" => "Slovak",
    "sl" => "Slovenian",
    "sm" => "Samoan",
    "sn" => "Shona",
    "so" => "Somali",
    "sq" => "Albanian",
    "sr" => "Serbian",
    "ss" => "Swati",
    "st" => "Southern Sotho",
    "su" => "Sundanese",
    "sv" => "Swedish",
    "sw" => "Swahili",
    "ta" => "Tamil",
    "te" => "Telugu",
    "tg" => "Tajik",
    "th" => "Thai",
    "ti" => "Tigrinya",
    "tk" => "Turkmen",
    "tl" => "Tagalog",
    "tn" => "Tswana",
    "to" => "Tonga",
    "tr" => "Turkish",
    "ts" => "Tsonga",
    "tt" => "Tatar",
    "tw" => "Twi",
    "ty" => "Tahitian",
    "ug" => "Uighur",
    "uk" => "Ukrainian",
    "ur" => "Urdu",
    "uz" => "Uzbek",
    "ve" => "Venda",
    "vi" => "Vietnamese",
    "vo" => "Volapuk",
    "wa" => "Walloon",
    "wo" => "Wolof",
    "xh" => "Xhosa",
    "yi" => "Yiddish",
    "yo" => "Yoruba",
    "za" => "Zhuang",
    "zh" => "Chinese",
    "zu" => "Zulu"
    );
    return array_search($name, $languageCodes);
}

function isLogged() {
  if(isset($_SESSION['auth'])) {
    return true;
  } else {
    return false;
  }
}

function url_get_contents($url){
   if(function_exists('curl_init') && function_exists('curl_setopt') && function_exists('curl_exec') && function_exists('curl_exec')){
     # Use cURL
     $curl = curl_init($url);

     curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
     curl_setopt($curl, CURLOPT_HEADER, 0);
     curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
     curl_setopt($curl, CURLOPT_TIMEOUT, 5);
     if(stripos($url,'https:') !== false){
         curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
         curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
     }
     $content = @curl_exec($curl);
     curl_close($curl);
   }else{
     # Use FGC, because cURL is not supported
     ini_set('default_socket_timeout',5);
     $content = @file_get_contents($url);
   }
   return $content;
}

function geoinfo() {
  $user_ip = $_SERVER['REMOTE_ADDR'];
  $user_info = url_get_contents('http://www.geoplugin.net/json.gp?ip='.$user_ip);
  return json_decode($user_info,true);
}

function _hash($str) {
  return md5($str);
}

function coordsToCity($lat,$lng) {
$geocode=url_get_contents('http://maps.googleapis.com/maps/api/geocode/json?latlng='.$lat.','.$lng.'&sensor=false');
$output= json_decode($geocode);
return $output->results[0]->address_components[2]->long_name;
}

if(isset($_POST['register'])) {

// Geolocation
$geo = geoinfo();

$full_name = ucwords($_POST['full_name']);
$email = $_POST['email'];
$password = trim($_POST['password']);
$time = time();
$age = $_POST['age'];
$gender = $_POST['gender'];

$country = $geo['geoplugin_countryName'];
$city = '';
$ip = $_SERVER['REMOTE_ADDR'];
$latitude = $geo['geoplugin_latitude'];
$longitude = $geo['geoplugin_longitude'];

// Check duplicate
$check_d = $db->query("SELECT id FROM users WHERE email='".$email."'")->num_rows;
if($check_d == 0) {
$db->query("INSERT INTO users(profile_picture,full_name,email,password,registered,country,city,energy,age,gender,ip,latitude,longitude,local_range) VALUES ('default_avatar.png','$full_name','$email','"._hash($password)."','$time','$country','$city','10','$age','$gender','$ip','$latitude','$longitude','0,500')");
setcookie('justRegistered', 'true', time()+6);
setcookie('mm-email',$email,time()+60*60*24*30,'/');
header('Location: app/login.php');
exit;
}
}

if(isLogged()) {
$first_name = explode(' ', $_SESSION['full_name']);
$first_name = $first_name[0];
}

// Language Autodetect
$userlang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
$lang_dir = scandir('app/languages');
foreach($lang_dir as $file) { 
if($userlang == getLocaleCodeForDisplayLanguage(ucfirst($file))) {
$_SESSION['lang'] = $file;
}
}

?>
<!DOCTYPE HTML>
<!--[if lt IE 7 ]><html class="ie ie6 ie-lt10 ie-lt9 ie-lt8 ie-lt7 no-js" lang="en"><![endif]-->
<!--[if IE 7 ]><html class="ie ie7 ie-lt10 ie-lt9 ie-lt8 no-js" lang="en"><![endif]-->
<!--[if IE 8 ]><html class="ie ie8 ie-lt10 ie-lt9 no-js" lang="en"><![endif]-->
<!--[if IE 9 ]><html class="ie ie9 ie-lt10 no-js" lang="en"><![endif]-->
<!--[if gt IE 9]><!--><html class="no-js" lang="en"><!--<![endif]-->
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<meta charset="utf-8">
<title><?php echo $site_name?> - Online Dating Community</title>
<meta name="keywords" content="" />
<meta name="description" content="" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimum-scale=1.0, maximum-scale=1.0" />
<link href='https://fonts.googleapis.com/css?family=Source+Sans+Pro:400,300,600,700' rel='stylesheet' type='text/css'>
<link href="<?php echo $domain?>/vendor/landing/font-awesome-4.3.0/css/font-awesome.min.css" rel="stylesheet">
<link href="<?php echo $domain?>/vendor/landing/animate.min.css" rel="stylesheet" />
<style>
.btn {
display: inline-block;
margin-bottom: 0;
font-weight: 400;
text-align: center;
vertical-align: middle;
touch-action: manipulation;
cursor: pointer;
background-image: none;
border: 1px solid transparent;
white-space: nowrap;
padding: 6px 16px;
font-size: 14px;
line-height: 1.52857143;
border-radius: 4px;
-webkit-user-select: none;
-moz-user-select: none;
-ms-user-select: none;
user-select: none;
}
.btn-red {
border:none !important; 
}
.btn-group-lg>.btn, .btn-lg {
padding: 10px 20px;
font-size: 18px;
line-height: 1.33;
border-radius: 6px;
}
.btn-block {
display: block;
width:100%; 
}
</style>
<link rel="stylesheet" href="<?php echo $domain?>/vendor/bootstrap-social/bootstrap-social.css">
<link rel="stylesheet" type="text/css" href="<?php echo $domain?>/vendor/landing/styles.css" />
<?php 
  if($theme == 'default') { echo '<link rel="stylesheet" href="'.$domain.'/app/css/theme-red.css">'; } 
  else { echo '<link rel="stylesheet" href="'.$domain.'/app/themes/'.$theme.'/theme.css">'; }
?>
<!--[if lt IE 9]>
  <script src="scripts/html5.js"></script>
<![endif]-->
<style>
body {
font-family: 'Source Sans Pro', sans-serif;
}
.header3 .btn {
  border:none;
}
.parsley-required {
  color:#f05050;
  margin-bottom:10px;
}
.features {
border-bottom:none;
}
</style>
</head>
<body>

<!-- Header -->
<header class="header header3" role="banner" id="header" style="background-image: url('vendor/landing/bg-header.jpg')">
  <div class="container">
     <div style="float:left;position:relative;z-index:2;"> <p><img src="app/img/logo.png"></p> </div>
    <div class="cta">
      <h4>It’s quick &amp; easy to</h4>
      <h1 style="font-size:40px;" class="theme-color">Meet new people online</h1>
      <p><?php echo $site_name?> is great for chatting, making friends, sharing interests, and even dating! Did we mention it's free?</p>
    </div>

    <div class="reg-form has-feedback">
      <?php if(!isLogged()) { ?>
      <a href="<?php echo $domain?>/app/login" style="color:#fff;font-size:17px;float:right;"> <i class="fa fa-sign-in fa-fw"></i> Log In </a>
      <br><br>
      <h3>Register in one easy step</h3>
      <form action="app/fb-login.php" method="POST">
      <button type="submit" name="fb-login" class="btn btn-block btn-social btn-lg btn-facebook"><i class="fa fa-facebook"></i>Register with Facebook</button> <br>
      </form>
      <form action="" method="post" id="registration">
        <input type="text" name="full_name" placeholder="Full name" required/>
        <input type="text" name="email" placeholder="Email" required/>
        <input type="password" name="password" placeholder="Password" required/>
        <select name="age" autocomplete="off" required class="form-control">
        <option value="" disabled selected>Age</option>
           <?php for($i = 16; $i <= 100; $i++) { ?>
           <option value="<?php echo $i?>"> <?php echo $i?> </option>
           <?php } ?>
        </select>
        <select name="gender" autocomplete="off" required class="form-control">
            <option value="" disabled selected>Gender</option>
            <option value="Male"> Male </option>
            <option value="Female"> Female </option>
        </select>
        <button type="submit" name="register" class="btn-red">Register today!</button>
      </form>
      <? } else { ?>
      <div style="text-align:center;padding-top:50px;">
      <h3>Welcome, <b><?php echo $first_name?></b> </h3>
       <form action="<?php echo $domain?>/app/people" method="GET">
       <button type="submit" class="btn-red">Log In</button>
       </form>
      </div>
      <? } ?>
    </div>

  </div>
</header>
<!-- Header ends -->

<main class="front-page main" role="main">

  <!-- Profiles -->
  <section class="profiles">
    <div class="container">

      <h3>Meet our community members</h3>

      <div class="flexslider carousel">
        <ul class="slides">

          <?php while($user = $users->fetch_array()) { $split_name = explode(' ', $user['full_name']); ?>
          <li>
            <div class="thumb">
              <a href="#" class="open-popup"><img src="<?php echo getProfilePicture($domain,$user)?>" style="border-radius:5px;"></a>
            </div>
            <p><a href="#" class="open-popup"><?php echo $split_name[0]?></a></p>
            <span><?php echo $user['age']?>, <?php echo $user['country']?></span>
          </li>
          <?php } ?>

        </ul>
      </div>

    </div>
  </section>
  <!-- Profiles Ends! -->

  <!-- Features -->
  <section class="features">

    <h2><?php echo $site_name?> revolutionizes online dating <br/> <a href="#" class="back-to-top theme-color"> Give it a try, it’s free to join. </a> </h2>

    <div class="container">

      <!-- Block -->
      <div class="block">
        <i class="fa fa-smile-o theme-color"></i>
        <h3>It's Free</h3>
        <p>
        Signing up takes two
minutes and is totally free. What do you have to loose?
       </p>
      </div>
      <!-- Block Ends ! -->

      <!-- Block -->
      <div class="block">
        <i class="fa fa-check theme-color"></i>
        <h3>Smart Matching</h3>
        <p>
        Our matching algorithm helps
you find the right people.
        </p>
      </div>
      <!-- Block Ends ! -->

      <!-- Block -->
      <div class="block">
        <i class="fa fa-map-marker theme-color"></i>
        <h3>It's Localized</h3>
        <p>Connect with the singles from your local <br> town or city.</p>
      </div>
      <!-- Block Ends ! -->

    </div>
  </section>
  <!-- Features Ends! -->

</main>
<!-- Main Ends! -->

<script src="<?php echo $domain?>/vendor/landing/scripts/modernizr.js"></script>
<script src="<?php echo $domain?>/vendor/landing/scripts/jquery-1.11.0.min.js"></script>
<script src="<?php echo $domain?>/vendor/landing/scripts/jquery.flexslider-min.js"></script>
<script src="<?php echo $domain?>/vendor/landing/scripts/jquery.parallax-1.1.3.js"></script>
<script src="<?php echo $domain?>/vendor/landing/scripts/jquery.localscroll-1.2.7-min.js"></script>
<script src="<?php echo $domain?>/vendor/landing/scripts/jquery.scrollTo-1.4.2-min.js"></script>
<script src="<?php echo $domain?>/vendor/landing/scripts/jquery.inview.min.js"></script>
<script src="<?php echo $domain?>/vendor/landing/scripts/theme.js"></script>
<script src="<?php echo $domain?>/vendor/parsleyjs/dist/parsley.min.js"></script>
<script type="text/javascript">$("#registration").parsley();</script>

</body>
</html>
<!-- Localized -->